/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.mongodb.ConnectionCloseReason;
import com.lubanops.apm.plugin.mongodb.ConnectionPoolHolder;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MongoUtils {
    private static volatile Method getDescriptionCache;
    private static volatile Method isClosedCache;
    private static volatile Method getGenerationCache;

    public static ServerId getServerId(Object connection) throws Exception {
        ConnectionDescription description = MongoUtils.getConnectionDescription(connection);
        return description.getConnectionId().getServerId();
    }

    public static ConnectionDescription getConnectionDescription(Object connection) throws Exception {
        if (getDescriptionCache == null) {
            throw new NoSuchMethodException("Cannot load getDescription method.");
        }
        return (ConnectionDescription)getDescriptionCache.invoke(connection, new Object[0]);
    }

    public static Boolean isClosed(Object connection) throws Exception {
        if (isClosedCache == null) {
            throw new NoSuchMethodException("Cannot load isClosed method.");
        }
        return (Boolean)isClosedCache.invoke(connection, new Object[0]);
    }

    public static int getGeneration(Object connection) throws Exception {
        if (getGenerationCache == null) {
            throw new NoSuchMethodException("Cannot load getGeneration method.");
        }
        return (Integer)getGenerationCache.invoke(connection, new Object[0]);
    }

    private static void setGetDescriptionMethod(Class<?> resultClass) throws NoSuchMethodException {
        getDescriptionCache = resultClass.getMethod("getDescription", new Class[0]);
        getDescriptionCache.setAccessible(true);
    }

    private static void setIsClosedMethod(Class<?> resultClass) throws NoSuchMethodException {
        isClosedCache = resultClass.getMethod("isClosed", new Class[0]);
        isClosedCache.setAccessible(true);
    }

    private static void setGetGenerationMethod(Class<?> resultClass) throws NoSuchMethodException {
        getGenerationCache = resultClass.getMethod("getGeneration", new Class[0]);
        getGenerationCache.setAccessible(true);
    }

    private static void setClassInfo() {
        try {
            Class<?> resultClass = Class.forName("com.mongodb.internal.connection.InternalConnection");
            MongoUtils.setCachedMethod(resultClass);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> resultClass = Class.forName("com.mongodb.connection.InternalConnection");
                MongoUtils.setCachedMethod(resultClass);
            }
            catch (ClassNotFoundException e2) {
                LogFactory.getLogger().log(Level.SEVERE, "Unsupported Mongo Driver Version", (Throwable)e);
            }
        }
    }

    private static void setCachedMethod(Class<?> connectionClass) {
        try {
            MongoUtils.setGetDescriptionMethod(connectionClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MongoUtils.setIsClosedMethod(connectionClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MongoUtils.setGetGenerationMethod(connectionClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static String getConnectionAddress(Object usageTrackingConnection) throws Exception {
        ConnectionDescription description = MongoUtils.getConnectionDescription(usageTrackingConnection);
        return description.getServerAddress().toString();
    }

    public static ConnectionCloseReason getConnectionCloseReason(Object usageTrackingConnection) throws Exception {
        ConnectionCloseReason reason = MongoUtils.isClosed(usageTrackingConnection) != false ? ConnectionCloseReason.ERROR : (MongoUtils.fromPreviousGeneration(usageTrackingConnection) ? ConnectionCloseReason.STALE : (MongoUtils.pastMaxLifeTime(usageTrackingConnection) ? ConnectionCloseReason.MAX_LIFE_TIME_EXCEEDED : (MongoUtils.pastMaxIdleTime(usageTrackingConnection) ? ConnectionCloseReason.MAX_IDLE_TIME_EXCEEDED : ConnectionCloseReason.POOL_CLOSED)));
        return reason;
    }

    private static boolean fromPreviousGeneration(Object usageTrackingConnection) throws Exception {
        int poolGeneration;
        ServerId serverId = MongoUtils.getServerId(usageTrackingConnection);
        Object pool = ConnectionPoolHolder.getPool(serverId);
        Object poolGenerationHolder = ((AttributeAccess)pool).getLopsFileds()[3];
        if (poolGenerationHolder != null) {
            poolGeneration = ((AtomicInteger)poolGenerationHolder).get();
        } else {
            try {
                poolGenerationHolder = ((AttributeAccess)pool).getLopsFileds()[4];
                poolGeneration = (Integer)((AttributeAccess)poolGenerationHolder).getLopsFileds()[0];
            }
            catch (Exception e) {
                LogFactory.getLogger().log(Level.SEVERE, "Unsupported Mongo Driver Version", (Throwable)e);
                return false;
            }
        }
        Object generationHolder = ((AttributeAccess)usageTrackingConnection).getLopsFileds()[2];
        int generation = generationHolder != null ? (Integer)generationHolder : MongoUtils.getGeneration(usageTrackingConnection);
        return poolGeneration > generation;
    }

    private static boolean pastMaxIdleTime(Object usageTrackingConnection) throws Exception {
        ServerId serverId = MongoUtils.getServerId(usageTrackingConnection);
        Long lastUsedAt = (Long)((AttributeAccess)usageTrackingConnection).getLopsFileds()[1];
        return MongoUtils.expired(lastUsedAt, System.currentTimeMillis(), MongoUtils.getConnectionSetting(serverId).getMaxConnectionIdleTime(TimeUnit.MILLISECONDS));
    }

    private static boolean pastMaxLifeTime(Object usageTrackingConnection) throws Exception {
        ServerId serverId = MongoUtils.getServerId(usageTrackingConnection);
        Long openedAt = (Long)((AttributeAccess)usageTrackingConnection).getLopsFileds()[0];
        return MongoUtils.expired(openedAt, System.currentTimeMillis(), MongoUtils.getConnectionSetting(serverId).getMaxConnectionLifeTime(TimeUnit.MILLISECONDS));
    }

    private static ConnectionPoolSettings getConnectionSetting(ServerId serverId) {
        Object pool = ConnectionPoolHolder.getPool(serverId);
        return (ConnectionPoolSettings)((AttributeAccess)pool).getLopsFileds()[1];
    }

    private static boolean expired(long startTime, long curTime, long maxTime) {
        return maxTime != 0L && curTime - startTime > maxTime;
    }

    static {
        MongoUtils.setClassInfo();
    }
}

