/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.mongodb.connection.ServerId;

public class GetConnectionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"MongoDb");
                ServerId serverId = (ServerId)((AttributeAccess)object).getLopsFileds()[0];
                MongoDbCollector.connectionOnStart(serverId.getAddress().toString());
            }
        }
        catch (Exception getConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getConnectionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                MongoDbCollector.connectionOnThrowable(e);
                TraceCollector.onError((Throwable)e);
            }
        }
        catch (Exception getConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getConnectionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                String res;
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                String string = res = result == null ? "Failed" : "Successful";
                if (spanEvent != null) {
                    if (spanEvent.getTimeUsed() >= (long)MongoDbCollector.INSTANCE.getTimeSpanThreshold()) {
                        spanEvent.addTag("Result", res);
                        TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                    }
                }
                MongoDbCollector.connectionOnFinally();
            }
        }
        catch (Exception getConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getConnectionException);
        }
    }
}

