/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.ConsumerMethodAggregator;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.KafkaConsumerFetchAggregator;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.KafkaConsumerPartitionAggregator;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.KafkaConsumerTopicAggregator;
import java.util.Map;

public class KafkaConsumerCollector
extends Collector {
    public static final KafkaConsumerCollector INSTANCE = new KafkaConsumerCollector();
    private static final KafkaConsumerTopicAggregator TOPIC_AGGREGATOR = new KafkaConsumerTopicAggregator();
    private static final KafkaConsumerFetchAggregator FETCH_AGGREGATOR = new KafkaConsumerFetchAggregator();
    private static final KafkaConsumerPartitionAggregator PARTITION_AGGREGATOR = new KafkaConsumerPartitionAggregator();
    private static final ConsumerMethodAggregator CONSUMER_AGGREGATOR = new ConsumerMethodAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    static ThreadLocal<Map<String, Object>> context = new ThreadLocal();
    public static final String STARTTIME_KEY = "startTime";
    public static final String STATSBASE_KEY = "statsBase";
    static ThreadLocal<Boolean> errorContext = new ThreadLocal();

    public static KafkaConsumerCollector getInstance() {
        return INSTANCE;
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "KafkaConsumer";
    }

    public static Map<String, Object> onStart(String method) {
        Map<String, Object> map = CONSUMER_AGGREGATOR.onStart(method);
        context.set(map);
        return map;
    }

    public static void onError() {
        Object stats;
        Map<String, Object> map = context.get();
        if (map != null && (stats = map.get(STATSBASE_KEY)) != null && stats instanceof UrlStats) {
            CONSUMER_AGGREGATOR.onError((UrlStats)stats);
        }
    }

    public static void onError(Throwable t) {
        Boolean bl = errorContext.get();
        if (bl != null) {
            return;
        }
        EXCEPTION_AGGREGATOR.onThrowable(t);
        errorContext.set(Boolean.TRUE);
    }

    public static void clearErrorContext() {
        errorContext.remove();
    }

    public static void onFinally() {
        Map<String, Object> map = context.get();
        if (map != null) {
            Object stats = map.get(STATSBASE_KEY);
            Long startTime = (Long)map.get(STARTTIME_KEY);
            if (stats != null && stats instanceof UrlStats) {
                CONSUMER_AGGREGATOR.onFinally((UrlStats)stats, startTime);
            }
            context.set(null);
        }
    }

    public static void clearWhenExceedLimit(String clientId) {
        FETCH_AGGREGATOR.removeClientIdFromMaps(clientId);
        TOPIC_AGGREGATOR.removeClientIdFromMaps(clientId);
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)TOPIC_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)FETCH_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)PARTITION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CONSUMER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

