/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.console.interceptor;

import com.huawei.console.service.context.entity.Router;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class Console2Interceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (result != null && result instanceof List) {
            List resultList = (List)result;
            ConcurrentSkipListSet set = UrlStatsConfig.newUrlList();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < resultList.size(); ++i) {
                Object apiListObj = resultList.get(i);
                if (!(apiListObj instanceof Router)) continue;
                Router routerObj = (Router)apiListObj;
                String router = routerObj.getRouter();
                if (!StringUtils.isBlank((String)router) && !"/".equals(router)) {
                    set.add(router + "/**");
                    set.add("/api" + router + "/**");
                    continue;
                }
                this.addRouter(routerObj, map);
            }
            if (set.size() > 0) {
                UrlStatsConfig.setSpringUrlList((Set)set);
            }
            if (map.size() > 0) {
                UrlStatsConfig.setCf2Router(map);
            }
        }
    }

    private void addRouter(Router routerObj, Map<String, String> map) {
        String serviceDomain = routerObj.getServiceDomain();
        String serviceId = routerObj.getServiceId();
        try {
            serviceId = routerObj.getServiceName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (serviceDomain != null) {
            String[] domains;
            for (String domain : domains = serviceDomain.split(",")) {
                map.put(domain, "/" + serviceId + "/**");
            }
        }
    }
}

