/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;

public final class ClientObjectHolder {
    private static AtomicInteger num = new AtomicInteger(0);
    private static CopyOnWriteArrayList<RestClient> holder = new CopyOnWriteArrayList();

    public static Integer acquireNum() {
        return num.incrementAndGet();
    }

    public static void register(RestClient client) {
        if (holder.size() < 10) {
            holder.add(client);
            CloseableHttpAsyncClient innerClient = (CloseableHttpAsyncClient)((AttributeAccess)client).getLopsFileds()[1];
            if (innerClient instanceof AttributeAccess) {
                NHttpClientConnectionManager connectionManager = (NHttpClientConnectionManager)((AttributeAccess)innerClient).getLopsFileds()[0];
                TransformAccessUtils.saveToLopsAttributeMap((Object)connectionManager, (String)"isInEs", (Object)Boolean.TRUE);
            }
        }
    }

    public static CopyOnWriteArrayList<RestClient> getClientList() {
        return holder;
    }

    public static Integer getOrRegister(RestClient client) {
        Integer number = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)client, (String)"clientId");
        if (number == null) {
            ClientObjectHolder.register(client);
            number = ClientObjectHolder.acquireNum();
            TransformAccessUtils.saveToLopsAttributeMap((Object)client, (String)"clientId", (Object)number);
        }
        return number;
    }

    public static String saveEsNodes(RestClient client, Collection<Node> nodes) {
        String res = ClientObjectHolder.nodesToString(nodes);
        TransformAccessUtils.saveToLopsAttributeMap((Object)client, (String)"esNodes", (Object)res);
        return res;
    }

    public static String saveEsNodes(RestClient client, HttpHost[] hosts) {
        String res = ClientObjectHolder.hostsToString(hosts);
        TransformAccessUtils.saveToLopsAttributeMap((Object)client, (String)"esNodes", (Object)res);
        return res;
    }

    public static String getDeadNodes(RestClient client) {
        StringBuilder res = new StringBuilder();
        for (Object object : ((ConcurrentHashMap)((AttributeAccess)client).getLopsFileds()[0]).keySet()) {
            HttpHost host = (HttpHost)object;
            String hostAndPort = host.getHostName() + ":" + host.getPort();
            if (res.length() == 0) {
                res = new StringBuilder(hostAndPort);
                continue;
            }
            res.append(",").append(hostAndPort);
        }
        return res.toString();
    }

    public static String nodesToString(Collection<Node> nodes) {
        StringBuilder res = new StringBuilder();
        for (Node node : nodes) {
            HttpHost host = node.getHost();
            if (host == null) continue;
            String hostAndPort = host.getHostName() + ":" + host.getPort();
            if (res.length() == 0) {
                res = new StringBuilder(hostAndPort);
                continue;
            }
            res.append(",").append(hostAndPort);
        }
        return res.toString();
    }

    public static String hostsToString(HttpHost[] hosts) {
        StringBuilder res = new StringBuilder();
        for (HttpHost host : hosts) {
            if (host == null) continue;
            String hostAndPort = host.getHostName() + ":" + host.getPort();
            if (res.length() == 0) {
                res = new StringBuilder(hostAndPort);
                continue;
            }
            res.append(",").append(hostAndPort);
        }
        return res.toString();
    }
}

