/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import java.security.ProtectionDomain;
import java.util.Collection;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class SetNodesInterceptor
implements Interceptor {
    public SetNodesInterceptor() {
        EsRestClientCollector.setRestClientVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)RestClient.class.getProtectionDomain()));
        EsRestClientCollector.setRestHighLevelClientVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)RestHighLevelClient.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"EsRestClient");
            }
        }
        catch (Exception setNodesException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)setNodesException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            CloseableHttpAsyncClient innerClient;
            RestClient client = (RestClient)object;
            String clusterNodes = null;
            if (args[0] instanceof Collection) {
                clusterNodes = ClientObjectHolder.saveEsNodes(client, (Collection)args[0]);
            } else if (args[0] instanceof HttpHost[]) {
                clusterNodes = ClientObjectHolder.saveEsNodes(client, (HttpHost[])args[0]);
            }
            if (clusterNodes != null && (innerClient = (CloseableHttpAsyncClient)((AttributeAccess)client).getLopsFileds()[1]) instanceof AttributeAccess) {
                NHttpClientConnectionManager connectionManager = (NHttpClientConnectionManager)((AttributeAccess)innerClient).getLopsFileds()[0];
                TransformAccessUtils.saveToLopsAttributeMap((Object)connectionManager, (String)"esClusterNodes", (Object)clusterNodes);
            }
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
            }
        }
        catch (Exception setNodesException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)setNodesException);
        }
    }
}

