/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.client.RestClient;

public class EsClusterStats
extends DefaultSectionStats {
    private static final String CLIENT_COUNT = "clientCount";
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private String orderedEsNodes;

    public void setOrderedEsNodes(String orderedEsNodes) {
        this.orderedEsNodes = orderedEsNodes;
    }

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        row.put((Object)CLIENT_COUNT, (Object)this.getNumOfClients());
        return row;
    }

    private int getNumOfClients() {
        CopyOnWriteArrayList<RestClient> clientList = ClientObjectHolder.getClientList();
        int count = 0;
        for (RestClient client : clientList) {
            String esNodes = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)client, (String)"esNodes");
            String orderedEsNodes = EsUtils.getOrderedEsNodes(esNodes);
            if (this.orderedEsNodes == null || !this.orderedEsNodes.equals(orderedEsNodes)) continue;
            ++count;
        }
        return count;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"lastError", this.lastError.getAndSet(null));
        row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        row.put((Object)CLIENT_COUNT, (Object)this.getNumOfClients());
        return row;
    }
}

