/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.moquette.broker.processors;

import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttMessageProcessor;
import io.moquette.broker.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;

public class MqttPublishMessageProcessor
implements MqttMessageProcessor {
    @Override
    public boolean process(ChannelHandlerContext ctx, MqttMessage msg, SpanEvent spanEvent) {
        if (!(msg instanceof MqttPublishMessage)) {
            return false;
        }
        MqttPublishMessage mqttPublishMessage = (MqttPublishMessage)msg;
        String operationName = "Mqtt/PUBLISH";
        spanEvent.setMethod(spanEvent.getMethod() + "(" + operationName + ")");
        spanEvent.addTag("mqtt.clientId", NettyUtils.clientID((Channel)ctx.channel()));
        spanEvent.addTag("mqtt.messageId", String.valueOf(mqttPublishMessage.variableHeader().packetId()));
        spanEvent.addTag("mqtt.topic", mqttPublishMessage.variableHeader().topicName());
        spanEvent.addTag("mqtt.username", NettyUtils.userName((Channel)ctx.channel()));
        spanEvent.addTag("mqtt.qos", msg.fixedHeader().qosLevel().name());
        return true;
    }
}

