/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hikari.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.hikari.collector.HikariDBConnectionAggregator;
import com.lubanops.apm.plugin.hikari.collector.HikariDataSourceAggregator;
import com.zaxxer.hikari.pool.HikariPool;
import java.util.Map;

public class HikariCollector
extends Collector {
    public static final HikariCollector INSTANCE = new HikariCollector();
    private static final HikariDataSourceAggregator HIKARI_DATA_SOURCE_AGGREGATOR = new HikariDataSourceAggregator();
    private static final HikariDBConnectionAggregator HIKARI_DB_CONNECTION_AGGREGATOR = new HikariDBConnectionAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    private static final DefaultVersionAggregator DEFAULT_VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public void parseParameter(Map<String, String> parameters) {
        HIKARI_DB_CONNECTION_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "Hikari";
    }

    public static void onStart(HikariPool pool) {
        HIKARI_DB_CONNECTION_AGGREGATOR.onStart(pool.config.getJdbcUrl());
        HIKARI_DATA_SOURCE_AGGREGATOR.onstart(pool);
    }

    public static void onThrowable(Throwable t) {
        HIKARI_DB_CONNECTION_AGGREGATOR.onThrowable(t);
        EXCEPTION_AGGREGATOR.onThrowable(t);
    }

    public static void onFinally() {
        HIKARI_DB_CONNECTION_AGGREGATOR.onFinally();
    }

    public static void setDriverVersion(String driverVersion) {
        DEFAULT_VERSION_AGGREGATOR.setVersion(driverVersion);
    }

    public int getTimeSpanThreshold() {
        return HIKARI_DB_CONNECTION_AGGREGATOR.getTimeSpanThreshold();
    }

    public boolean isGetPoolInfo() {
        return HIKARI_DB_CONNECTION_AGGREGATOR.isGetPoolInfo();
    }

    public Integer getActiveCount() {
        return HIKARI_DB_CONNECTION_AGGREGATOR.getActiveCount();
    }

    public Integer getPoolingCount() {
        return HIKARI_DB_CONNECTION_AGGREGATOR.getPoolingCount();
    }

    public Integer getWaitThreadCount() {
        return HIKARI_DB_CONNECTION_AGGREGATOR.getWaitThreadCount();
    }

    public void setCounts(int activeCount, int poolingCount, int waitThreadCount) {
        HIKARI_DB_CONNECTION_AGGREGATOR.setCounts(activeCount, poolingCount, waitThreadCount);
    }

    public void clearCounts() {
        HIKARI_DB_CONNECTION_AGGREGATOR.clearCounts();
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)HIKARI_DATA_SOURCE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)HIKARI_DB_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)DEFAULT_VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

