/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.httpasyncclient.collector.ApacheHttpAsyncClientCollector;
import com.lubanops.apm.plugin.httpasyncclient.collector.NioConnectionStats;
import java.util.Map;
import org.apache.http.conn.routing.HttpRoute;

public class LeaseRequestConInterceptor
implements Interceptor {
    private static final String STATUS = "Status";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            SpanEvent spanEvent;
            if (ApacheHttpAsyncClientCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"ApacheHttpAsyncClient")) != null) {
                spanEvent.addTag(STATUS, "Pending.");
            }
        }
        catch (Exception leaseRequestConstructorException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)leaseRequestConstructorException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (ApacheHttpAsyncClientCollector.INSTANCE.isEnable()) {
                HttpRoute httpRoute = (HttpRoute)args[0];
                Map<String, Object> map = ApacheHttpAsyncClientCollector.INSTANCE.onStart(httpRoute.toString());
                Long startTime = (Long)map.get("startTime");
                NioConnectionStats stats = (NioConnectionStats)((Object)map.get("stats"));
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"startTime", (Object)startTime);
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"stats", (Object)((Object)stats));
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null) {
                    TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"spanEvent", (Object)spanEvent);
                }
            }
        }
        catch (Exception leaseRequestConstructorException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)leaseRequestConstructorException);
        }
    }
}

