/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.JetcdUtils;
import io.etcd.jetcd.api.CampaignRequest;
import io.etcd.jetcd.api.CompactionRequest;
import io.etcd.jetcd.api.DeleteRangeRequest;
import io.etcd.jetcd.api.LeaderKey;
import io.etcd.jetcd.api.LeaderRequest;
import io.etcd.jetcd.api.LeaseGrantRequest;
import io.etcd.jetcd.api.LeaseRevokeRequest;
import io.etcd.jetcd.api.LeaseTimeToLiveRequest;
import io.etcd.jetcd.api.ProclaimRequest;
import io.etcd.jetcd.api.PutRequest;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.api.ResignRequest;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.UnlockRequest;

class RequestProcessHelper {
    RequestProcessHelper() {
    }

    public static String parseAndProcessRequest(Object request, SpanEvent spanEvent, JetcdServiceType type) {
        String requestType = null;
        switch (type) {
            case KV: {
                requestType = RequestProcessHelper.parseAndProcessKvRequest(request, spanEvent);
                break;
            }
            case LEASE: {
                requestType = RequestProcessHelper.parseAndProcessLeaseRequest(request, spanEvent);
                break;
            }
            case LOCK: {
                requestType = RequestProcessHelper.parseAndProcessLockRequest(request, spanEvent);
                break;
            }
            case ELECTION: {
                requestType = RequestProcessHelper.parseAndProcessElectionRequest(request, spanEvent);
                break;
            }
        }
        return requestType;
    }

    public static String parseAndProcessKvRequest(Object request, SpanEvent spanEvent) {
        String requestType = null;
        if (request instanceof RangeRequest) {
            requestType = RequestProcessHelper.addTag4RangeRequest((RangeRequest)request, spanEvent);
        } else if (request instanceof PutRequest) {
            requestType = RequestProcessHelper.addTag4PutRequest((PutRequest)request, spanEvent);
        } else if (request instanceof DeleteRangeRequest) {
            requestType = RequestProcessHelper.addTag4DeleteRequest((DeleteRangeRequest)request, spanEvent);
        } else if (request instanceof TxnRequest) {
            requestType = RequestProcessHelper.addTag4TxnRequest((TxnRequest)request, spanEvent);
        } else if (request instanceof CompactionRequest) {
            requestType = RequestProcessHelper.addTag4CompactionRequest((CompactionRequest)request, spanEvent);
        }
        return requestType;
    }

    public static String parseAndProcessLeaseRequest(Object request, SpanEvent spanEvent) {
        String requestType = null;
        if (request instanceof LeaseGrantRequest) {
            requestType = RequestProcessHelper.addTag4LeaseGrantRequest((LeaseGrantRequest)request, spanEvent);
        } else if (request instanceof LeaseRevokeRequest) {
            requestType = RequestProcessHelper.addTag4LeaseRevokeRequest((LeaseRevokeRequest)request, spanEvent);
        } else if (request instanceof LeaseTimeToLiveRequest) {
            requestType = RequestProcessHelper.addTag4LeaseTimeToLiveRequest((LeaseTimeToLiveRequest)request, spanEvent);
        }
        return requestType;
    }

    public static String parseAndProcessLockRequest(Object request, SpanEvent spanEvent) {
        String requestType = null;
        if (request instanceof LockRequest) {
            requestType = RequestProcessHelper.addTag4LockRequest((LockRequest)request, spanEvent);
        } else if (request instanceof UnlockRequest) {
            requestType = RequestProcessHelper.addTag4UnlockRequest((UnlockRequest)request, spanEvent);
        }
        return requestType;
    }

    public static String parseAndProcessElectionRequest(Object request, SpanEvent spanEvent) {
        String requestType = null;
        if (request instanceof CampaignRequest) {
            requestType = RequestProcessHelper.addTag4CampaignRequest((CampaignRequest)request, spanEvent);
        } else if (request instanceof ProclaimRequest) {
            requestType = RequestProcessHelper.addTag4ProclaimRequest((ProclaimRequest)request, spanEvent);
        } else if (request instanceof LeaderRequest) {
            requestType = RequestProcessHelper.addTag4LeaderRequest((LeaderRequest)request, spanEvent);
        } else if (request instanceof ResignRequest) {
            requestType = RequestProcessHelper.addTag4ResignRequest((ResignRequest)request, spanEvent);
        }
        return requestType;
    }

    public static String addTag4RangeRequest(RangeRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String key = request.getKey().toStringUtf8();
            String rangeEnd = request.getRangeEnd().toStringUtf8();
            long limit = request.getLimit();
            long revision = request.getRevision();
            boolean serializable = request.getSerializable();
            long minCreateRevision = request.getMinCreateRevision();
            long maxCreateRevision = request.getMaxCreateRevision();
            long minModRevision = request.getMinModRevision();
            long maxModRevision = request.getMaxModRevision();
            spanEvent.addTag("key", key);
            spanEvent.addTag("range_end", rangeEnd);
            spanEvent.addTag("limit", String.valueOf(limit));
            spanEvent.addTag("revision", String.valueOf(revision));
            spanEvent.addTag("serializable", String.valueOf(serializable));
            spanEvent.addTag("min_create_revision", String.valueOf(minCreateRevision));
            spanEvent.addTag("max_create_revision", String.valueOf(maxCreateRevision));
            spanEvent.addTag("min_mod_revision", String.valueOf(minModRevision));
            spanEvent.addTag("max_mod_revision", String.valueOf(maxModRevision));
            return "RangeRequest";
        }
        return null;
    }

    public static String addTag4PutRequest(PutRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String key = request.getKey().toStringUtf8();
            String value = request.getValue().toStringUtf8();
            long lease = request.getLease();
            boolean prevKv = request.getPrevKv();
            boolean ignoreValue = request.getIgnoreValue();
            boolean ignoreLease = request.getIgnoreLease();
            spanEvent.addTag("key", key);
            spanEvent.addTag("value", JetcdUtils.getEncryptedValIfSet(value));
            spanEvent.addTag("lease", String.valueOf(lease));
            spanEvent.addTag("prev_kv", String.valueOf(prevKv));
            spanEvent.addTag("ignore_value", String.valueOf(ignoreValue));
            spanEvent.addTag("ignore_lease", String.valueOf(ignoreLease));
            return "PutRequest";
        }
        return null;
    }

    public static String addTag4DeleteRequest(DeleteRangeRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String key = request.getKey().toStringUtf8();
            String rangeEnd = request.getRangeEnd().toStringUtf8();
            boolean prevKv = request.getPrevKv();
            spanEvent.addTag("key", key);
            spanEvent.addTag("range_end", rangeEnd);
            spanEvent.addTag("prev_kv", String.valueOf(prevKv));
            return "DeleteRangeRequest";
        }
        return null;
    }

    public static String addTag4TxnRequest(TxnRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            return "TxnRequest";
        }
        return null;
    }

    public static String addTag4CompactionRequest(CompactionRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            long revision = request.getRevision();
            boolean physical = request.getPhysical();
            spanEvent.addTag("revision", String.valueOf(revision));
            spanEvent.addTag("physical", String.valueOf(physical));
            return "CompactionRequest";
        }
        return null;
    }

    public static String addTag4LeaseGrantRequest(LeaseGrantRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            long ttl = request.getTTL();
            long id = request.getID();
            spanEvent.addTag("ttl", String.valueOf(ttl));
            spanEvent.addTag("id", String.valueOf(id));
            return "LeaseGrantRequest";
        }
        return null;
    }

    public static String addTag4LeaseRevokeRequest(LeaseRevokeRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            long id = request.getID();
            spanEvent.addTag("id", String.valueOf(id));
            return "LeaseRevokeRequest";
        }
        return null;
    }

    public static String addTag4LeaseTimeToLiveRequest(LeaseTimeToLiveRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            long id = request.getID();
            boolean keys = request.getKeys();
            spanEvent.addTag("id", String.valueOf(id));
            spanEvent.addTag("keys", String.valueOf(keys));
            return "LeaseTimeToLiveRequest";
        }
        return null;
    }

    public static String addTag4LockRequest(LockRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String name = request.getName().toStringUtf8();
            long lease = request.getLease();
            spanEvent.addTag("name", name);
            spanEvent.addTag("lease", String.valueOf(lease));
            return "LockRequest";
        }
        return null;
    }

    public static String addTag4UnlockRequest(UnlockRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String key = request.getKey().toStringUtf8();
            spanEvent.addTag("key", key);
            return "UnlockRequest";
        }
        return null;
    }

    public static String addTag4CampaignRequest(CampaignRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String name = request.getName().toStringUtf8();
            long lease = request.getLease();
            String value = request.getValue().toStringUtf8();
            spanEvent.addTag("name", name);
            spanEvent.addTag("lease", String.valueOf(lease));
            spanEvent.addTag("value", JetcdUtils.getEncryptedValIfSet(value));
            return "CampaignRequest";
        }
        return null;
    }

    public static String addTag4ProclaimRequest(ProclaimRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            LeaderKey leader = request.getLeader();
            String value = request.getValue().toStringUtf8();
            spanEvent.addTag("leader", JetcdUtils.getLeaderKeyAsTag(leader));
            spanEvent.addTag("value", JetcdUtils.getEncryptedValIfSet(value));
            return "ProclaimRequest";
        }
        return null;
    }

    public static String addTag4LeaderRequest(LeaderRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            String name = request.getName().toStringUtf8();
            spanEvent.addTag("name", name);
            return "LeaderRequest";
        }
        return null;
    }

    public static String addTag4ResignRequest(ResignRequest request, SpanEvent spanEvent) {
        if (request != null && spanEvent != null) {
            LeaderKey leader = request.getLeader();
            spanEvent.addTag("leader", JetcdUtils.getLeaderKeyAsTag(leader));
            return "ResignRequest";
        }
        return null;
    }
}

