/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.PreparedStatement;
import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;
import java.sql.SQLException;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                GoldenDBTrace.onStart(className, methodName, sql, preparedStatement.asSql(), id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable throwable, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                PreparedStatementInteceptor.onError(sql, throwable);
                GoldenDBTrace.onError(throwable);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object mysqlObject, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable()) break block7;
                PreparedStatement preparedStatement = (PreparedStatement)mysqlObject;
                String sql = preparedStatement.getPreparedSql();
                int updatedRowCount = 0;
                ResultSetImpl resultSet = null;
                int readRowCount = 0;
                try {
                    updatedRowCount = preparedStatement.getUpdateCount();
                    resultSet = (ResultSetImpl)preparedStatement.getResultSet();
                    if (resultSet != null && (readRowCount = Integer.valueOf(String.valueOf(resultSet.getUpdateCount())).intValue()) == -1) {
                        readRowCount = 1;
                    }
                }
                catch (SQLException ex) {
                    LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    GoldenDBTrace.onFinally(updatedRowCount, readRowCount, (TransformAccess)resultSet);
                } else {
                    GoldenDBTrace.onFinally(updatedRowCount, readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

