/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.server.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.grpc.server.collector.SeverCollector;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Map;

public class CloseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (SeverCollector.INSTANCE.isEnable()) {
            Object attributeObject;
            Status status = (Status)args[0];
            Metadata metadata = (Metadata)args[1];
            metadata.put(Metadata.Key.of((String)Headers.ENV_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(IdentityConfigManager.getEnvId()));
            boolean isError = false;
            Throwable throwable = status.getCause();
            if (SeverCollector.getContext() != null) {
                if (throwable != null) {
                    TraceCollector.onError((Throwable)throwable);
                }
                TraceCollector.addTag((String)"status", (String)status.getCode().name());
                TraceCollector.onFinally((int)status.getCode().value(), (boolean)isError);
                if (object instanceof TransformAccess) {
                    ((TransformAccess)object).setLopsAttribute(null);
                }
            } else if (object instanceof TransformAccess && (attributeObject = ((TransformAccess)object).getLopsAttribute()) != null && attributeObject instanceof Map) {
                Map map = (Map)attributeObject;
                SpanEvent spanEvent = (SpanEvent)map.get("spanEvent");
                Map serverContext = (Map)map.get("serverCollectorContext");
                SeverCollector.setContext(serverContext);
                if (spanEvent != null) {
                    spanEvent.addTag("status", status.getCode().name());
                    TraceCollector.onFinallySpanEvent((int)status.getCode().value(), (boolean)isError, (SpanEvent)spanEvent);
                }
                ((TransformAccess)object).setLopsAttribute(null);
            }
            if (!status.isOk()) {
                isError = true;
                SeverCollector.onError();
            }
            SeverCollector.onFinally();
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

