/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.profiler;

import com.huawei.cloud.profiler.pap.v1.Metadata;
import com.huawei.cloud.profiler.pap.v1.PControlRequest;
import com.huawei.cloud.profiler.pap.v1.PlatformType;
import com.huawei.cloud.profiler.pap.v1.ProcessType;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.core.profiler.ProfilerConfig;
import java.util.ArrayList;

public class ProfilerController {
    private static ProfilerController instance;

    public static synchronized ProfilerController getInstance() {
        if (instance == null) {
            instance = new ProfilerController();
        }
        return instance;
    }

    public void createControlRequest(ProfilerConfig profilerConfig) {
        PControlRequest.Payload payload;
        Metadata metadata;
        if (profilerConfig == null) {
            return;
        }
        Metadata.Builder metaBuilder = Metadata.newBuilder().setSessionId(String.valueOf(IdentityConfigManager.getInstanceId())).setProcessId(String.valueOf(IdentityConfigManager.getAppId())).setProcessType(ProcessType.JVM).setPlatformType(PlatformType.PROCESS).putAdditionalParams("tenantId", String.valueOf(IdentityConfigManager.getDomainId())).putAdditionalParams("profilingIntervalInTime", profilerConfig.getProfilingIntervalInTime()).putAdditionalParams("profilingIntervalInData", profilerConfig.getProfilingIntervalInData());
        if (profilerConfig.getProfilingDataTypes().isEmpty()) {
            metadata = metaBuilder.setMessageType(PControlRequest.StopProfilingSession.class.getSimpleName()).build();
            payload = PControlRequest.Payload.newBuilder().setStopProfilingSession(PControlRequest.StopProfilingSession.newBuilder().setReason("NORMAL").build()).build();
        } else {
            metadata = metaBuilder.setMessageType(PControlRequest.StartProfilingSession.class.getSimpleName()).build();
            payload = PControlRequest.Payload.newBuilder().setStartProfilingSession(PControlRequest.StartProfilingSession.newBuilder().addAllProfileDetails(this.getProfileDetailsList(profilerConfig)).build()).build();
        }
        PControlRequest pControlRequest = PControlRequest.newBuilder().setMetadata(metadata).setPayload(payload).build();
        ProfilerService.getInstance().setWallEnable(profilerConfig.getProfilingDataTypes().contains(PControlRequest.SupportedProfilingDataType.LATENCY));
        ProfilerService.getInstance().sessionControl(pControlRequest.toByteArray());
    }

    private Iterable<PControlRequest.MapEntry> getProfileDetailsList(ProfilerConfig config) {
        ArrayList<PControlRequest.MapEntry> mapEntryList = new ArrayList<PControlRequest.MapEntry>();
        for (PControlRequest.SupportedProfilingDataType type : config.getProfilingDataTypes()) {
            if (type == null) continue;
            mapEntryList.add(PControlRequest.MapEntry.newBuilder().setKey(type).setValue(1).build());
        }
        return mapEntryList;
    }
}

