/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.UpdataListenerManager;
import com.lubanops.apm.bootstrap.collector.UpdateListener;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.AtomicDouble;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import com.lubanops.apm.plugin.collector.jvm.JVMAggregatorEnum;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JVMCpuAggregator
extends NonePrimaryKeyAggregator
implements UpdateListener {
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private ObjectName operatingSystemBean = null;
    private double processorCount = 1.0;
    private Long lastProcessCpuTime = null;
    private Long lastSystemTime = null;
    private Long lastProcessCpuTimeMax = null;
    private Long lastSystemTimeMax = null;
    private AtomicDouble maxCpuRatio = new AtomicDouble(0.0);

    JVMCpuAggregator() {
        try {
            this.processorCount = this.getRealProcessorCount();
            ObjectName objName = new ObjectName("java.lang:type=OperatingSystem");
            Set<ObjectName> nn = this.server.queryNames(objName, null);
            if (nn != null && !nn.isEmpty()) {
                this.operatingSystemBean = nn.iterator().next();
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().severe(e.getMessage());
        }
        if (this.operatingSystemBean != null) {
            this.lastProcessCpuTimeMax = this.lastProcessCpuTime = this.getProcessCpuTime();
            this.lastSystemTimeMax = this.lastSystemTime = Long.valueOf(System.nanoTime());
            UpdataListenerManager.registerListener((UpdateListener)this);
        }
    }

    public String getName() {
        return JVMAggregatorEnum.cpu.name();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    private Long getProcessCpuTime() {
        if (this.operatingSystemBean == null) {
            return null;
        }
        try {
            Object o = this.server.getAttribute(this.operatingSystemBean, "ProcessCpuTime");
            if (o != null) {
                return Long.parseLong(o.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void clear() {
    }

    public MonitorDataRow constructItemRow() {
        return this.constructItemRowInternal(true);
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        return this.constructItemRowInternal(false);
    }

    public List<MonitorDataRow> getAllStatus() {
        MonitorDataRow row = this.constructItemRowInternal(false);
        return row == null ? null : Collections.singletonList(row);
    }

    private MonitorDataRow constructItemRowInternal(boolean reset) {
        Long currentProcessTime = this.getProcessCpuTime();
        if (currentProcessTime == null || this.lastProcessCpuTime == null) {
            return null;
        }
        long currentSystemTime = System.nanoTime();
        long cpuTimeInterval = currentProcessTime - this.lastProcessCpuTime;
        long sysTimeInterval = currentSystemTime - this.lastSystemTime;
        double ratio = (double)cpuTimeInterval / (double)sysTimeInterval * 100.0 / this.processorCount;
        Stats.setCpuRatio((double)ratio);
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"processorCount", (Object)this.processorCount);
        row.put((Object)"totalCpuTime", (Object)currentProcessTime);
        row.put((Object)"cpuTimeInterval", (Object)cpuTimeInterval);
        row.put((Object)"systemTimeInterval", (Object)sysTimeInterval);
        row.put((Object)"cpuRatio", (Object)ratio);
        row.put((Object)"cpuRatioMax", (Object)Math.max(this.maxCpuRatio.get(), ratio));
        if (reset) {
            this.maxCpuRatio.set(0.0);
            this.lastProcessCpuTime = currentProcessTime;
            this.lastSystemTime = currentSystemTime;
        }
        return row;
    }

    public void update() {
        Long currentProcessTime = this.getProcessCpuTime();
        if (currentProcessTime == null) {
            return;
        }
        long currentSystemTime = System.nanoTime();
        long cpuTimeInterval = currentProcessTime - this.lastProcessCpuTimeMax;
        long sysTimeInterval = currentSystemTime - this.lastSystemTimeMax;
        double ratio = (double)cpuTimeInterval / (double)sysTimeInterval * 100.0 / this.processorCount;
        this.lastProcessCpuTimeMax = currentProcessTime;
        this.lastSystemTimeMax = currentSystemTime;
        ConcurrentUtil.setMaxValue((AtomicDouble)this.maxCpuRatio, (double)ratio);
    }

    public double getMaxCpuRatio() {
        return this.maxCpuRatio.get();
    }

    private double getRealProcessorCount() {
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }
}

