/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvminfo;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.collector.jvminfo.JVMInfoAggregatorEnum;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JVMInfoAggregator
extends NonePrimaryKeyAggregator {
    private OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private RuntimeMXBean rtMbean = ManagementFactory.getRuntimeMXBean();
    private MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
    private String sdkVersion;

    JVMInfoAggregator() {
    }

    public String getName() {
        return JVMInfoAggregatorEnum.info.name();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public MonitorDataRow constructItemRow() {
        String encodeing;
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"arch", (Object)this.osBean.getArch());
        row.put((Object)"osName", (Object)this.osBean.getName());
        row.put((Object)"osVersion", (Object)this.osBean.getVersion());
        row.put((Object)"systemLoadAverage", (Object)this.osBean.getSystemLoadAverage());
        row.put((Object)"availableProcessors", (Object)this.osBean.getAvailableProcessors());
        row.put((Object)"startTime", (Object)this.rtMbean.getStartTime());
        row.put((Object)"inputArguments", (Object)this.rtMbean.getInputArguments().toString());
        row.put((Object)"javaSpecificationVersion", (Object)this.rtMbean.getManagementSpecVersion());
        row.put((Object)"javaLibraryPath", (Object)this.rtMbean.getLibraryPath());
        row.put((Object)"classPath", (Object)this.rtMbean.getClassPath());
        row.put((Object)"name", (Object)this.rtMbean.getName());
        row.put((Object)"vmName", (Object)this.rtMbean.getVmName());
        row.put((Object)"vmVendor", (Object)this.rtMbean.getVmVendor());
        row.put((Object)"vmVersion", (Object)this.rtMbean.getVmVersion());
        row.put((Object)"specName", (Object)this.rtMbean.getSpecName());
        row.put((Object)"specVendor", (Object)this.rtMbean.getSpecVendor());
        row.put((Object)"specVersion", (Object)this.rtMbean.getSpecVersion());
        row.put((Object)"uptime", (Object)this.rtMbean.getUptime());
        row.put((Object)"jvm", (Object)System.getProperties().getProperty("java.vm.info"));
        row.put((Object)"javaVersion", (Object)System.getProperties().getProperty("java.version"));
        row.put((Object)"javaCollectorVersion", (Object)AgentInfo.getJavaagentVersion());
        row.put((Object)"sdkVersion", (Object)this.getSDKVersion());
        String name = this.rtMbean.getName();
        String pid = "";
        if (name != null) {
            int i = name.indexOf("@");
            pid = i > 1 ? name.substring(0, i) : name;
        }
        row.put((Object)"pid", (Object)pid);
        String home = System.getProperties().getProperty("java.home");
        if (home != null) {
            row.put((Object)"javaHome", (Object)home);
        }
        if ((encodeing = System.getProperties().getProperty("file.encoding")) != null) {
            row.put((Object)"fileEncode", (Object)encodeing);
        }
        return row;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    private String getSDKVersion() {
        if (this.sdkVersion == null) {
            try {
                Iterator<ObjectName> iterator;
                String objname = "wiseapm:type=javasdk,name=info";
                ObjectName objName = new ObjectName(objname);
                Set<ObjectName> nn = this.beanServer.queryNames(objName, null);
                if (nn != null && !nn.isEmpty() && (iterator = nn.iterator()).hasNext()) {
                    ObjectName obj = iterator.next();
                    this.sdkVersion = this.beanServer.getAttribute(obj, "version").toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sdkVersion;
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

