/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStats;
import java.util.concurrent.atomic.AtomicLong;

public class MqttPublishStats
extends DefaultStats {
    public static final String MESSAGE_SENT_COUNT = "msgSentCount";
    public static final String BYTES_SENT = "bytesSent";
    protected final AtomicLong msgSentCount = new AtomicLong(0L);
    protected final AtomicLong bytesSent = new AtomicLong(0L);
    protected volatile long msgSentCountCountOld;
    protected volatile long bytesSentOld;

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        if (row != null) {
            row.put((Object)MESSAGE_SENT_COUNT, (Object)this.msgSentCount);
            row.put((Object)BYTES_SENT, (Object)this.bytesSent);
        }
        return row;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow row = super.harvest();
        if (row == null) {
            row = new MonitorDataRow();
        }
        long msgSentCountNew = this.msgSentCount.get();
        long bytesSentNew = this.bytesSent.get();
        row.put((Object)MESSAGE_SENT_COUNT, (Object)(msgSentCountNew - this.msgSentCountCountOld));
        row.put((Object)BYTES_SENT, (Object)(bytesSentNew - this.bytesSentOld));
        this.msgSentCountCountOld = msgSentCountNew;
        this.bytesSentOld = bytesSentNew;
        return row;
    }

    public void onSendMsg(int bytesCount) {
        this.msgSentCount.incrementAndGet();
        this.bytesSent.addAndGet(bytesCount);
    }
}

