/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionCounter;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqCommonCollector;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;

public class ChannelOpenInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqCommonCollector.INSTANCE.isEnable()) {
                RabbitMqCommonCollector.onException(e);
            }
            this.hasErrorLocal.set(Boolean.TRUE);
        }
        catch (Exception rabbitChannelOpenException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitChannelOpenException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Boolean isStarted;
            boolean hasError = false;
            if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                hasError = true;
            }
            if (!hasError && !Boolean.TRUE.equals(isStarted = (Boolean)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"isStarted"))) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"isStarted", (Object)Boolean.TRUE);
                ChannelN channelN = (ChannelN)object;
                AMQConnection connection = channelN.getConnection();
                String connectionStr = connection.toString();
                RabbitConnectionCounter.incrementChannelCount(connectionStr);
                RabbitMqCommonCollector.onChannelCreation(connectionStr);
            }
            this.hasErrorLocal.remove();
        }
        catch (Exception rabbitChannelOpenException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitChannelOpenException);
        }
    }
}

