/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.producer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.producer.collector.RabbitMqProducerCollector;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;

public class BasicPublishInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqProducerCollector.initTag();
            if (RabbitMqProducerCollector.INSTANCE.isEnable()) {
                ChannelN channelN = (ChannelN)object;
                String exchange = (String)args[0];
                String routingKey = (String)args[1];
                AMQConnection connection = channelN.getConnection();
                String connectionAsString = connection.toString();
                String channelNum = String.valueOf(channelN.getChannelNumber());
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqProducer");
                RabbitMqProducerCollector.onPublishStart(connection, exchange);
                AMQP.BasicProperties properties = (AMQP.BasicProperties)args[4];
                if (spanEvent != null) {
                    spanEvent.addTag("exchange", exchange);
                    spanEvent.addTag("connection", connectionAsString);
                    spanEvent.addTag("channelNum", channelNum);
                    spanEvent.addTag("routingKey", routingKey);
                    String traceId = spanEvent.getTraceId();
                    properties = RabbitMqUtils.propertiesWithLubanAttr(properties, traceId);
                }
                return new Object[]{args[0], args[1], args[2], args[3], properties, args[5]};
            }
        }
        catch (Exception rabbitMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqPublishException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqProducerCollector.INSTANCE.isEnable()) {
                RabbitMqProducerCollector.onException(e);
                RabbitMqProducerCollector.onError(TraceCollector.getTraceId());
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception rabbitMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqPublishException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RabbitMqProducerCollector.INSTANCE.isEnable()) {
                boolean hasError = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    hasError = true;
                }
                int bytesCount = hasError ? 0 : ((byte[])args[5]).length;
                RabbitMqProducerCollector.onPublishFinally(bytesCount, hasError);
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception rabbitMqPublishException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqPublishException);
        }
    }
}

