/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka;

import com.lubanops.apm.bootstrap.NoneNamedListener;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaConsumerCollector;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.ConsumerMethodAggregator;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator.MethodPattern;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.kafka.consumer.KafkaConsumerInvokeInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class CustomizationConsumerListener
implements NoneNamedListener {
    public void init() {
    }

    public List<String> matchClass(String className, byte[] classfileBuffer) {
        if (className == null) {
            return null;
        }
        if (className.startsWith("sun/") || className.startsWith("java/") || className.startsWith("javax/")) {
            return null;
        }
        if (className.startsWith("com/lubanops/apm/bootstrap") || className.startsWith("com/lubanops/apm/premain") || className.startsWith("com/lubanops/apm/transformer")) {
            return null;
        }
        if (className.contains("$")) {
            return null;
        }
        ConsumerMethodAggregator consumerMethodAggregator = (ConsumerMethodAggregator)KafkaConsumerCollector.INSTANCE.getModelAggregatorMap().get("consumer");
        List methodPatterns = consumerMethodAggregator.getMethodPatterns();
        for (MethodPattern methodPattern : methodPatterns) {
            boolean isMatch = Pattern.matches(methodPattern.getClassName(), className);
            if (!isMatch) continue;
            String methods = methodPattern.getMethodNames();
            if (!StringUtils.isBlank((String)methods)) {
                String[] methodArray = methods.split(",");
                return Arrays.asList(methodArray);
            }
            return new ArrayList<String>();
        }
        return null;
    }

    public boolean hasAttribute() {
        return false;
    }

    public boolean appendBootstrapClassLoader() {
        return false;
    }

    public String getInterceptor() {
        return KafkaConsumerInvokeInterceptor.class.getName();
    }
}

