/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.consumer;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaConsumerCollector;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerConfig;

public class KafkaConsumerInterceptor
implements Interceptor {
    private boolean isInited = false;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (!this.isInited) {
            CollectorManager.TAGS.add("KafkaConsumer");
            KafkaConsumerCollector.getInstance();
            this.isInited = true;
        }
        return null;
    }

    private String getClientId(Object object) {
        Object[] filedObjs;
        if (object instanceof AttributeAccess && (filedObjs = ((AttributeAccess)object).getLopsFileds()).length > 0) {
            return (String)filedObjs[0];
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (KafkaConsumerCollector.INSTANCE.isEnable()) {
            KafkaConsumerCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (args.length > 0) {
            Map map = null;
            String clientId = null;
            if (args[0] instanceof ConsumerConfig) {
                map = ((ConsumerConfig)args[0]).originals();
                clientId = ((ConsumerConfig)args[0]).getString("client.id");
            } else if (args[0] instanceof Map) {
                map = (Map)args[0];
                clientId = this.getClientId(object);
            }
            if (clientId != null && map != null && KafkaHelper.CONSUMERINFO.getIp(clientId) == null) {
                Object ips = map.get("bootstrap.servers");
                KafkaHelper.CONSUMERINFO.addIp(clientId, ips != null ? ips.toString() : "unknow");
            }
        }
        KafkaConsumerCollector.clearErrorContext();
    }
}

