/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.impl.consumer.DefaultLitePullConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;

public class RocketMqUtils {
    public static final int TRUNCATE_LIMIT = 1000;

    public static String getClientId(DefaultMQProducerImpl producerImpl) {
        Object[] attributes = ((AttributeAccess)producerImpl).getLopsFileds();
        DefaultMQProducer clientConfig = (DefaultMQProducer)attributes[0];
        MQClientInstance clientInstance = (MQClientInstance)attributes[1];
        String clientId = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)clientConfig, (String)"reformattedClientId");
        if (clientId == null) {
            clientId = clientInstance.getClientId();
        }
        return clientId;
    }

    public static String getClientId(DefaultMQPushConsumerImpl consumerImpl) {
        Object[] attributes = ((AttributeAccess)consumerImpl).getLopsFileds();
        DefaultMQPushConsumer clientConfig = (DefaultMQPushConsumer)attributes[0];
        MQClientInstance clientInstance = (MQClientInstance)attributes[1];
        String clientId = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)clientConfig, (String)"reformattedClientId");
        if (clientId == null) {
            clientId = clientInstance.getClientId();
        }
        return clientId;
    }

    public static String getClientId(DefaultMQPullConsumerImpl consumerImpl) {
        Object[] attributes = ((AttributeAccess)consumerImpl).getLopsFileds();
        DefaultMQPullConsumer clientConfig = (DefaultMQPullConsumer)attributes[0];
        MQClientInstance clientInstance = (MQClientInstance)attributes[1];
        String clientId = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)clientConfig, (String)"reformattedClientId");
        if (clientId == null) {
            clientId = clientInstance.getClientId();
        }
        return clientId;
    }

    public static String getClientId(DefaultLitePullConsumerImpl consumerImpl) {
        Object[] attributes = ((AttributeAccess)consumerImpl).getLopsFileds();
        DefaultLitePullConsumer clientConfig = (DefaultLitePullConsumer)attributes[0];
        MQClientInstance clientInstance = (MQClientInstance)attributes[1];
        String clientId = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)clientConfig, (String)"reformattedClientId");
        if (clientId == null) {
            clientId = clientInstance.getClientId();
        }
        return clientId;
    }

    public static int getMessageCount(Message message) {
        AttributeAccess attributeAccess;
        List messageList;
        if (message == null) {
            return 0;
        }
        int count = 1;
        if (message instanceof MessageBatch && null != (messageList = (List)(attributeAccess = (AttributeAccess)message).getLopsFileds()[0])) {
            count = messageList.size();
        }
        return count;
    }

    public static String constructQueueFromMq(MessageQueue mq) {
        return mq.getTopic() + "_" + mq.getBrokerName() + "_" + mq.getQueueId();
    }

    public static String getMsgIds(List<MessageExt> msgList) {
        if (msgList == null || msgList.size() == 0) {
            return "No msg detected";
        }
        StringBuilder sb = new StringBuilder();
        for (MessageExt msg : msgList) {
            String msgId = msg.getMsgId();
            if (sb.length() == 0) {
                sb.append(msgId);
            } else {
                sb.append("; ").append(msgId);
            }
            if (sb.length() < 1000) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    public static String getQueueOffsets(List<MessageExt> msgList) {
        if (msgList == null || msgList.size() == 0) {
            return "No msg detected";
        }
        StringBuilder sb = new StringBuilder();
        for (MessageExt msg : msgList) {
            long queueOffset = msg.getQueueOffset();
            if (sb.length() == 0) {
                sb.append(queueOffset);
            } else {
                sb.append("; ").append(queueOffset);
            }
            if (sb.length() < 1000) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    public static String getTags(List<MessageExt> msgList) {
        if (msgList == null || msgList.size() == 0) {
            return "No msg detected";
        }
        StringBuilder sb = new StringBuilder();
        for (MessageExt msg : msgList) {
            String tags = msg.getTags();
            if (sb.length() == 0) {
                sb.append(tags);
            } else {
                sb.append("; ").append(tags);
            }
            if (sb.length() < 1000) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    public static int getMsgCount(List<MessageExt> msgList) {
        if (msgList == null) {
            return 0;
        }
        return msgList.size();
    }

    public static int getMsgBytes(List<MessageExt> msgList) {
        if (msgList == null) {
            return 0;
        }
        int msgBytes = 0;
        for (MessageExt msg : msgList) {
            msgBytes += msg.getBody().length;
        }
        return msgBytes;
    }

    public static String getBrokerAddresses(List<MessageExt> msgList) {
        if (msgList == null || msgList.size() == 0) {
            return "No msg detected";
        }
        return msgList.get(0).getStoreHost().toString().replace("/", "");
    }

    public static String getDeliverTimeDiffs(List<MessageExt> msgList) {
        if (msgList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean containsStartDeliverTime = false;
        for (MessageExt msg : msgList) {
            String startDeliverTimeString;
            long startDeliverTime = -1L;
            Map properties = msg.getProperties();
            if (properties.containsKey("__STARTDELIVERTIME") && (startDeliverTimeString = (String)properties.get("__STARTDELIVERTIME")).matches("\\d*")) {
                try {
                    startDeliverTime = Long.parseLong(startDeliverTimeString);
                }
                catch (NumberFormatException e) {
                    LogFactory.getLogger().log(Level.FINE, "Unexpected DeliverTime type.", (Throwable)e);
                }
            }
            String toAppend = "None";
            if (startDeliverTime != -1L) {
                containsStartDeliverTime = true;
                toAppend = String.valueOf(startDeliverTime);
            }
            if (sb.length() == 0) {
                sb.append(toAppend);
            } else {
                sb.append(",").append(toAppend);
            }
            if (sb.length() < 1000) continue;
            sb.append("...");
            break;
        }
        if (!containsStartDeliverTime) {
            return null;
        }
        return sb.toString();
    }

    public static int getReconsumeTimes(List<MessageExt> msgList) {
        if (msgList == null) {
            return 0;
        }
        int totalReconsumeTimes = 0;
        for (MessageExt msg : msgList) {
            int reconsumeTimes = msg.getReconsumeTimes();
            totalReconsumeTimes += reconsumeTimes;
        }
        return totalReconsumeTimes;
    }

    public static void setMsgTraceId(Message message) {
        Map properties;
        if (message == null) {
            return;
        }
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent != null && !(properties = message.getProperties()).containsKey("lubanOpsTraceId")) {
            properties.put("lubanOpsTraceId", spanEvent.getTraceId());
        }
    }

    public static String getMsgTraceId(Message message) {
        if (message == null) {
            return null;
        }
        Map properties = message.getProperties();
        if (properties.containsKey("lubanOpsTraceId")) {
            return (String)properties.get("lubanOpsTraceId");
        }
        return null;
    }

    public static String getMsgsTraceId(List<? extends Message> messageList) {
        if (messageList == null || messageList.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Message message : messageList) {
            String traceId = RocketMqUtils.getMsgTraceId(message);
            if (traceId != null) {
                if (builder.length() == 0) {
                    builder.append(traceId);
                } else {
                    builder.append(",").append(traceId);
                }
            }
            if (builder.length() < 1000) continue;
            builder.append("...");
            break;
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    public static long getLongValElseZero(MonitorDataRow row, String key) {
        Object val = row.get((Object)key);
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        return 0L;
    }
}

