/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.common.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rocketmq.RocketMqPidMapper;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.common.UtilAll;

public class BuildMQClientIdInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ClientConfig clientConfig = (ClientConfig)object;
            StringBuilder sb = new StringBuilder();
            sb.append("{ClientIP}");
            sb.append("@");
            Boolean isDefaultInstanceName = (Boolean)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"isDefaultInstanceName");
            if (Boolean.TRUE.equals(isDefaultInstanceName)) {
                sb.append("{PID}");
            } else {
                sb.append(clientConfig.getInstanceName());
            }
            if (!UtilAll.isBlank((String)clientConfig.getUnitName())) {
                sb.append("@");
                sb.append(clientConfig.getUnitName());
            }
            sb.append("|").append(clientConfig.getNamesrvAddr());
            String reformattedId = sb.toString();
            if (Boolean.TRUE.equals(isDefaultInstanceName)) {
                RocketMqPidMapper.register(reformattedId, clientConfig.getInstanceName());
            } else {
                RocketMqPidMapper.register(reformattedId, String.valueOf(UtilAll.getPid()));
            }
            TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"reformattedClientId", (Object)reformattedId);
        }
        catch (Exception buildMqClientIdException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)buildMqClientIdException);
        }
    }
}

