/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.rocketmq.common.stats.RocketMqInvokeStats;
import java.util.concurrent.atomic.AtomicLong;

public class RocketMqPullStats
extends RocketMqInvokeStats {
    private volatile long pulledMsgCountOld;
    private volatile long pulledBytesOld;
    private final AtomicLong pulledMsgCount = new AtomicLong();
    private final AtomicLong pulledBytes = new AtomicLong();

    public void incrementPulledMsgCount(int count) {
        this.pulledMsgCount.addAndGet(count);
    }

    public void incrementPulledMsgBytes(int count) {
        this.pulledBytes.addAndGet(count);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"pulledMsgCount", (Object)this.pulledMsgCount.get());
        row.put((Object)"pulledBytes", (Object)this.pulledBytes.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        long pulledMsgCountNew = this.pulledMsgCount.get();
        long pulledMsgBytesNew = this.pulledBytes.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"pulledMsgCount", (Object)(pulledMsgCountNew - this.pulledMsgCountOld));
            row.put((Object)"pulledBytes", (Object)(pulledMsgBytesNew - this.pulledBytesOld));
        }
        this.pulledMsgCountOld = pulledMsgCountNew;
        this.pulledBytesOld = pulledMsgBytesNew;
        return row;
    }
}

