/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.lettuce.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.lettuce.collector.LettuceCollector;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class InitializePartitionsInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (object instanceof AttributeAccess) {
            Object[] fieldObjects = ((AttributeAccess)object).getLopsFileds();
            Partitions partitions = (Partitions)fieldObjects[0];
            if (result instanceof CompletableFuture) {
                ((CompletableFuture)result).thenApply(it -> this.doClusterSwitch((Partitions)it));
            } else {
                this.doClusterSwitch(partitions);
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    private Partitions doClusterSwitch(Partitions partitions) {
        if (partitions != null && partitions.getPartitions() != null && partitions.getPartitions().size() > 0) {
            List clusterNodes = partitions.getPartitions();
            HashSet<String> nodeSet = new HashSet<String>();
            for (RedisClusterNode node : clusterNodes) {
                if (!node.getRole().name().equals("MASTER") && !node.getRole().name().equals("UPSTREAM")) continue;
                nodeSet.add(node.getUri().getHost() + ":" + node.getUri().getPort());
            }
            LettuceCollector.getInstance().onClusterSwitch(new ArrayList<String>(nodeSet));
        }
        return partitions;
    }
}

