/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.interceptor.StatsAroundInterceptor;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RedisStats
extends DefaultSectionStats
implements StatsAroundInterceptor {
    private static final String FIELD_LASTERROR = "lastError";
    private static final String HITS_FIELD = "hits";
    private static final String GET_INVOKE_COUNT = "getInvokeCount";
    private static final String BLOB_COUNT_FIELD = "blobCount";
    private static final String TRAFFIC_FIELD = "traffic";
    private static final String SLOW_TRACEID_FIELD = "slowTraceId";
    private static final String ERROR_TRACEID_FIELD = "errorTraceId";
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong getInvokeCount = new AtomicLong(0L);
    private final AtomicLong blobCount = new AtomicLong(0L);
    private final AtomicLong traffic = new AtomicLong(0L);
    private volatile long hitsOld;
    private volatile long getInvokeCountOld;
    private volatile long blobCountOld;
    private volatile long trafficOld;
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();

    public RedisStats() {
        this.initRanges(new int[]{5, 10, 50, 100, 1000});
    }

    public static void merge(MonitorDataRow dataRowFrom, MonitorDataRow dataRowDes) {
        DefaultSectionStats.merge((MonitorDataRow)dataRowFrom, (MonitorDataRow)dataRowDes);
        dataRowDes.put((Object)HITS_FIELD, (Object)(dataRowDes.get((Object)HITS_FIELD) == null ? (Long)dataRowFrom.get((Object)HITS_FIELD) : (Long)dataRowDes.get((Object)HITS_FIELD) + (Long)dataRowFrom.get((Object)HITS_FIELD)));
        dataRowDes.put((Object)GET_INVOKE_COUNT, (Object)(dataRowDes.get((Object)GET_INVOKE_COUNT) == null ? (Long)dataRowFrom.get((Object)GET_INVOKE_COUNT) : (Long)dataRowDes.get((Object)GET_INVOKE_COUNT) + (Long)dataRowFrom.get((Object)GET_INVOKE_COUNT)));
        dataRowDes.put((Object)BLOB_COUNT_FIELD, (Object)(dataRowDes.get((Object)BLOB_COUNT_FIELD) == null ? (Long)dataRowFrom.get((Object)BLOB_COUNT_FIELD) : (Long)dataRowDes.get((Object)BLOB_COUNT_FIELD) + (Long)dataRowFrom.get((Object)BLOB_COUNT_FIELD)));
        dataRowDes.put((Object)TRAFFIC_FIELD, (Object)(dataRowDes.get((Object)TRAFFIC_FIELD) == null ? (Long)dataRowFrom.get((Object)TRAFFIC_FIELD) : (Long)dataRowDes.get((Object)TRAFFIC_FIELD) + (Long)dataRowFrom.get((Object)TRAFFIC_FIELD)));
    }

    public void onThrowable(Throwable t) {
        super.onThrowable(t);
        String stackTrace = ExceptionUtil.getThrowableStackTrace((Throwable)t, (boolean)false);
        this.lastError.set(stackTrace);
    }

    public void setErrorTraceId(String traceId) {
        if (!StringUtils.isBlank((String)traceId)) {
            this.errorTraceId.set(traceId);
        }
    }

    public boolean onFinally(long timeInNanos, boolean isBlob, long bits, String traceId) {
        boolean res = Boolean.TRUE;
        boolean superRes = this.onFinally(System.nanoTime() - timeInNanos);
        if (superRes && !StringUtils.isBlank((String)traceId)) {
            this.slowTraceId.set(traceId);
        }
        this.traffic.addAndGet(bits);
        if (isBlob) {
            this.blobCount.getAndIncrement();
        }
        return res && superRes;
    }

    public boolean onFinally(long timeInNanos, boolean isBlob, boolean hit, long bits, String traceId, Boolean isRead) {
        boolean res = this.onFinally(timeInNanos, isBlob, bits, traceId);
        if (isRead.booleanValue()) {
            this.getInvokeCount.incrementAndGet();
        }
        if (hit) {
            this.hits.incrementAndGet();
        }
        if (isBlob) {
            this.blobCount.getAndIncrement();
        }
        return res;
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.add(HITS_FIELD, (Object)this.hits.get());
        row.add(GET_INVOKE_COUNT, (Object)this.getInvokeCount.get());
        row.add(BLOB_COUNT_FIELD, (Object)this.blobCount.get());
        row.add(TRAFFIC_FIELD, (Object)this.traffic.get());
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        long hitsNew = this.hits.get();
        long missNew = this.getInvokeCount.get();
        long blobCount = this.blobCount.get();
        long traffic = this.traffic.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (null == row) {
            return null;
        }
        row.put((Object)FIELD_LASTERROR, this.lastError.getAndSet(null));
        row.add(HITS_FIELD, (Object)(hitsNew - this.hitsOld));
        row.add(GET_INVOKE_COUNT, (Object)(missNew - this.getInvokeCountOld));
        row.add(BLOB_COUNT_FIELD, (Object)(blobCount - this.blobCountOld));
        row.add(TRAFFIC_FIELD, (Object)(traffic - this.trafficOld));
        row.add(ERROR_TRACEID_FIELD, this.errorTraceId.getAndSet(null));
        row.add(SLOW_TRACEID_FIELD, this.slowTraceId.getAndSet(null));
        this.reset(hitsNew, missNew, blobCount, traffic);
        return row;
    }

    private void reset(long hitsNew, long missNew, long blobCount, long traffic) {
        this.hitsOld = hitsNew;
        this.getInvokeCountOld = missNew;
        this.blobCountOld = blobCount;
        this.trafficOld = traffic;
    }

    public long onStart() {
        long t = System.nanoTime();
        return t;
    }

    public boolean onFinally(long timeInNanos) {
        return this.onFinallyNoRunningCount(timeInNanos);
    }
}

