/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class GnsConnectionPropParser {
    private static final Log LOGGER = Logger.getLogger(GnsConnectionPropParser.class.getName());

    public static void parseGnsServer(Properties urlProps) {
        String gnsServers = PGProperty.GNS.get(urlProps);
        if (gnsServers != null && !gnsServers.isEmpty()) {
            String[] addresses = gnsServers.split(",");
            PGProperty.GNS_HOSTS.set(urlProps, GnsConnectionPropParser.parseGnsHosts(addresses));
            PGProperty.GNS_PORTS.set(urlProps, GnsConnectionPropParser.parseGnsPort(addresses));
        }
    }

    private static String parseGnsHosts(String ... addresses) {
        StringBuilder gnsHosts = new StringBuilder();
        boolean isBegin = true;
        for (String address : addresses) {
            int portIdx = address.lastIndexOf(58);
            if (portIdx == -1 || address.lastIndexOf(93) >= portIdx) continue;
            CharSequence charSequence = address.subSequence(0, portIdx);
            String host = GnsConnectionPropParser.parseIPValid(charSequence.toString());
            if (isBegin) {
                gnsHosts.append(host);
                isBegin = false;
                continue;
            }
            gnsHosts.append(',').append(host);
        }
        return gnsHosts.toString();
    }

    private static String parseIPValid(String address) {
        if (address == null || address.isEmpty()) {
            return address;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(address).matches()) {
            LoggerUtil.warn(LOGGER, "JDBC URL invalid ip address: " + address);
        }
        return address;
    }

    private static String parseGnsPort(String ... addresses) {
        StringBuilder gnsPorts = new StringBuilder();
        boolean isBegin = true;
        for (String address : addresses) {
            String portStr;
            block5: {
                int portIdx = address.lastIndexOf(58);
                if (portIdx == -1 || address.lastIndexOf(93) >= portIdx) continue;
                portStr = address.substring(portIdx + 1);
                try {
                    int port = Integer.parseInt(portStr);
                    if (port < 1 || port > 65535) {
                        LoggerUtil.warn(LOGGER, "Gns URL port: " + portStr + " not valid (1:65535) ");
                    }
                    break block5;
                }
                catch (NumberFormatException ignore) {
                    LoggerUtil.warn(LOGGER, "Gns URL invalid port number: " + portStr);
                }
                continue;
            }
            if (isBegin) {
                gnsPorts.append(portStr);
                isBegin = false;
                continue;
            }
            gnsPorts.append(',').append(portStr);
        }
        return gnsPorts.toString();
    }

    public static List<HostSpec> getGnsHostSpecs(Properties props) {
        String gnsHosts = PGProperty.GNS_HOSTS.get(props);
        String gnsPorts = PGProperty.GNS_PORTS.get(props);
        if (gnsHosts.isEmpty() || gnsPorts.isEmpty()) {
            return new ArrayList<HostSpec>();
        }
        String[] hosts = gnsHosts.split(",");
        String[] ports = gnsPorts.split(",", hosts.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return Arrays.asList(hostSpecs);
    }

    public static String getAltClusterId(List<HostSpec> gnsHostSpecs) {
        Collections.sort(gnsHostSpecs, new Comparator<HostSpec>(){

            @Override
            public int compare(HostSpec o1, HostSpec o2) {
                return o1.getHost().compareTo(o2.getHost());
            }
        });
        return gnsHostSpecs.toString();
    }

    public static String getAltClusterId(Properties props) {
        List<HostSpec> gnsHostSpecs = GnsConnectionPropParser.getGnsHostSpecs(props);
        return GnsConnectionPropParser.getAltClusterId(gnsHostSpecs);
    }
}

