/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.log4j2.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.exception.common.collector.ExceptionCollector;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import io.opentelemetry.api.trace.Span;
import java.security.ProtectionDomain;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory2;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.MessageSupplier;

public class Log4j2Interceptor
implements Interceptor {
    private String version;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (object instanceof AttributeAccess) {
            Object[] fields = ((AttributeAccess)object).getLopsFileds();
            String logName = (String)fields[0];
            MessageFactory2 messageFactory = null;
            if (fields[1] instanceof MessageFactory2) {
                messageFactory = (MessageFactory2)fields[1];
            }
            if (!ExceptionCollector.hasContext() && null != args[3]) {
                this.setMDC();
                String msg = "";
                Throwable throwable = null;
                org.apache.logging.log4j.Level level = null;
                if (args[1] instanceof org.apache.logging.log4j.Level) {
                    level = (org.apache.logging.log4j.Level)args[1];
                }
                if (level != null && level.intLevel() <= StandardLevel.ERROR.intLevel()) {
                    Message message;
                    for (Object arg : args) {
                        if (!(arg instanceof Throwable)) continue;
                        throwable = (Throwable)arg;
                    }
                    if (args[3] instanceof String) {
                        msg = (String)args[3];
                    } else if (args[3] instanceof MessageSupplier) {
                        message = LambdaUtil.get((MessageSupplier)((MessageSupplier)args[3]));
                        msg = message.getFormattedMessage();
                        throwable = message.getThrowable();
                    } else if (args[3] instanceof Message) {
                        message = (Message)args[3];
                        msg = message.getFormattedMessage();
                        throwable = message.getThrowable();
                    } else if (null != messageFactory && args[3] instanceof CharSequence) {
                        message = messageFactory.newMessage(args[3]);
                        throwable = message.getThrowable();
                        msg = message.getFormattedMessage();
                    } else {
                        msg = args[3].toString();
                    }
                    ExceptionCollector.onError((String)logName, (String)("log4j2_" + level.name()), (Object)msg, (Throwable)throwable);
                }
            }
            if (this.version == null) {
                this.version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)object.getClass().getProtectionDomain());
                ExceptionCollector.setLog4j2Version((String)this.version);
            }
        }
        return new Object[0];
    }

    private void setMDC() {
        try {
            ThreadContext.getContext();
        }
        catch (Exception e) {
            return;
        }
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        String traceId = null;
        String spanId = null;
        if (spanEvent != null) {
            Span otelSpan = spanEvent.getOtelSpan();
            if (AgentConfigManager.isApmOtelEnabled() && otelSpan != null) {
                traceId = TraceCollector.getOtelTraceId((Span)otelSpan);
                spanId = TraceCollector.getOtelSpanId((Span)otelSpan);
            } else {
                traceId = spanEvent.getTraceId();
                spanId = spanEvent.getSpanId();
            }
        }
        String gtraceId = TraceCollector.getVirtualTraceId();
        if (traceId != null) {
            ThreadContext.put((String)"apm-traceid", traceId);
            ThreadContext.put((String)"apm-spanid", spanId);
            ThreadUtils.updateThreadName((String)traceId, (Boolean)ExceptionConfig.isLogPrintTrace());
        } else if (ThreadContext.get((String)"apm-traceid") != null) {
            ThreadContext.remove((String)"apm-traceid");
            ThreadUtils.resetThreadName();
        }
        if (gtraceId != null) {
            ThreadContext.put((String)"apm-gtraceid", (String)gtraceId);
        } else if (ThreadContext.get((String)"apm-gtraceid") != null) {
            ThreadContext.remove((String)"apm-gtraceid");
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ExceptionCollector.clearContext();
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "Log4j2Interceptor onFinally", (Throwable)e1);
        }
    }
}

