/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.MybatisIdThreadLocal;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlIdThreadLocal;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStats;
import com.lubanops.apm.bootstrap.utils.SqlParserUtil;
import com.lubanops.apm.bootstrap.utils.Util;
import java.util.List;
import java.util.Map;

public class JdbcStatsAggregator
extends SinglePrimaryKeyAggregator<SqlStats> {
    private static String tag_stats = "stats";
    private static String tag_start = "start";
    private static String tag_error = "error";
    private static String tag_stats2 = "stats2";
    private static String tag_start2 = "start2";

    public String getName() {
        return "sql";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected String primaryKey() {
        return "sqlId";
    }

    protected Class<SqlStats> getValueType() {
        return SqlStats.class;
    }

    protected void setPrimaryKey(MonitorDataRow row, String key) {
        if (row.get((Object)"sqlString") != null) {
            row.put((Object)"sql", (Object)key);
        } else {
            row.put((Object)"sql", (Object)Util.getMD5String((String)key));
            row.put((Object)"sqlString", (Object)key);
        }
    }

    public SqlStats onStart(String sql, Integer connectionId) {
        Map<String, String> mybatisIdMap = MybatisIdThreadLocal.THREAD_LOCAL.get();
        String mybatisId = null;
        String sqlString = null;
        SqlStats stats = null;
        if (mybatisIdMap != null) {
            mybatisId = mybatisIdMap.get(sql);
        }
        if (mybatisId != null) {
            stats = (SqlStats)this.getValue(mybatisId);
            stats.sqlString.set(sql);
            SqlIdThreadLocal.THREAD_LOCAL.set(mybatisId);
        } else {
            sqlString = SqlParserUtil.parse((String)sql);
            List<String> shardTableNames = MysqlCollector.CONFIG.getShardTableNames();
            if (shardTableNames.size() > 0) {
                sqlString = this.getShardTableSql(sqlString, shardTableNames);
            }
            stats = (SqlStats)this.getValue(sqlString);
            SqlIdThreadLocal.THREAD_LOCAL.set(Util.getMD5String((String)sqlString));
        }
        if (stats != null) {
            long startTime = stats.onStart();
            Map map = this.getContextMap();
            if (map.get(tag_stats) == null) {
                map.put(tag_stats, stats);
                map.put(tag_start, startTime);
            } else {
                map.put(tag_stats2, stats);
                map.put(tag_start2, startTime);
            }
        }
        if (connectionId != null) {
            stats.setLastDBName(Helper.CONNECTION_TARGET_MAP.getResource(connectionId.intValue()));
        }
        return stats;
    }

    private String getShardTableSql(String sql, List<String> shardTableNames) {
        boolean match = false;
        for (String shardTableName : shardTableNames) {
            String[] sqlArray = sql.split(" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < sqlArray.length; ++i) {
                String toChange;
                String sqlEle = sqlArray[i];
                if (i == 0) {
                    stringBuilder.append(sqlEle);
                } else {
                    stringBuilder.append(" ").append(sqlEle);
                }
                if (!sqlEle.equalsIgnoreCase("from") && !sqlEle.equalsIgnoreCase("update") && !sqlEle.equalsIgnoreCase("delete") || i + 1 >= sqlArray.length || !(toChange = sqlArray[i + 1]).startsWith(shardTableName)) continue;
                stringBuilder.append(" ").append(shardTableName);
                ++i;
                match = true;
            }
            if (!match) continue;
            return stringBuilder.toString();
        }
        return sql;
    }

    public void onThrowable(Throwable th) {
        Map map = this.getContextMap();
        SqlStats stat = (SqlStats)((Object)this.getContextValue(map, tag_stats));
        if (stat != null) {
            map.put(tag_error, true);
            stat.onThrowable(th);
        }
    }

    public void onFinally(int updatedRowCount, int readRowCount, int slowSqlRequestThreshold) {
        Map map;
        if (updatedRowCount < 0) {
            updatedRowCount = 0;
        }
        if (readRowCount < 0) {
            readRowCount = 0;
        }
        if ((map = this.getContextMap()).get(tag_stats2) == null) {
            SqlStats stat = (SqlStats)((Object)this.getContextValue(map, tag_stats));
            Long t = (Long)this.getContextValue(map, tag_start);
            if (stat != null) {
                stat.onFinally(System.nanoTime() - t, updatedRowCount, readRowCount, slowSqlRequestThreshold);
            }
            this.clearThreadLocal();
        } else {
            SqlStats stat = (SqlStats)((Object)this.getContextValue(map, tag_stats2));
            Long t = (Long)this.getContextValue(map, tag_start2);
            if (stat != null) {
                stat.onFinally(System.nanoTime() - t, updatedRowCount, readRowCount, slowSqlRequestThreshold);
            }
            map.remove(tag_stats2);
            map.remove(tag_start2);
        }
        SqlIdThreadLocal.THREAD_LOCAL.set(null);
    }
}

