/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;
import one.jfr.event.LiveObject;

public class jfr2flame {
    private static final String[] FRAME_SUFFIX = new String[]{"_[0]", "_[j]", "_[i]", "", "", "_[k]", "_[1]"};
    private final JfrReader jfr;
    private final Arguments args;
    private final Dictionary<String> methodNames = new Dictionary();

    public jfr2flame(JfrReader jfrReader, Arguments arguments) {
        this.jfr = jfrReader;
        this.args = arguments;
    }

    public void convert(final FlameGraph flameGraph) throws IOException {
        LiveObject liveObject;
        long l;
        EventAggregator eventAggregator = new EventAggregator(this.args.threads, this.args.total);
        Class<LiveObject> clazz = this.args.live ? LiveObject.class : (this.args.alloc ? AllocationSample.class : (this.args.lock ? ContendedLock.class : ExecutionSample.class));
        long l2 = 0L;
        if (this.args.state != null) {
            for (String string : this.args.state.split(",")) {
                int n = jfr2flame.getMapKey(this.jfr.threadStates, "STATE_" + string.toUpperCase());
                if (n < 0) continue;
                l2 |= 1L << n;
            }
        }
        long l3 = this.args.from != 0L ? this.toTicks(this.args.from) : Long.MIN_VALUE;
        long l4 = l = this.args.to != 0L ? this.toTicks(this.args.to) : Long.MAX_VALUE;
        while ((liveObject = this.jfr.readEvent(clazz)) != null) {
            if (liveObject.time < l3 || liveObject.time > l || l2 != 0L && (l2 & 1L << ((ExecutionSample)((Object)liveObject)).threadState) == 0L) continue;
            eventAggregator.collect(liveObject);
        }
        final double d = 1.0E9 / (double)this.jfr.ticksPerSec;
        final boolean bl = this.args.total && this.args.lock && d != 1.0;
        final Classifier classifier = new Classifier(this.methodNames);
        eventAggregator.forEach(new EventAggregator.Visitor(){

            @Override
            public void visit(Event event, long l) {
                StackTrace stackTrace = ((jfr2flame)jfr2flame.this).jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    Arguments arguments = jfr2flame.this.args;
                    long[] lArray = stackTrace.methods;
                    byte[] byArray = stackTrace.types;
                    int[] nArray = stackTrace.locations;
                    String string = jfr2flame.this.getClassFrame(event);
                    String[] stringArray = new String[lArray.length + (arguments.threads ? 1 : 0) + (arguments.classify ? 1 : 0) + (string != null ? 1 : 0)];
                    if (arguments.threads) {
                        stringArray[0] = jfr2flame.this.getThreadFrame(event.tid);
                    }
                    int n = stringArray.length;
                    if (string != null) {
                        stringArray[--n] = string;
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        int n2;
                        String string2 = jfr2flame.this.getMethodName(lArray[i], byArray[i]);
                        if (arguments.lines && (n2 = nArray[i] >>> 16) != 0) {
                            string2 = string2 + ":" + n2;
                        } else if (arguments.bci && (n2 = nArray[i] & 0xFFFF) != 0) {
                            string2 = string2 + "@" + n2;
                        }
                        stringArray[--n] = string2 + FRAME_SUFFIX[byArray[i]];
                    }
                    if (arguments.classify) {
                        stringArray[--n] = classifier.getCategoryName(stackTrace);
                    }
                    flameGraph.addSample(stringArray, bl ? (long)((double)l * d) : l);
                }
            }
        });
    }

    private String getThreadFrame(int n) {
        String string = this.jfr.threads.get(n);
        return string == null ? "[tid=" + n + ']' : '[' + string + " tid=" + n + ']';
    }

    private String getClassFrame(Event event) {
        String string;
        long l;
        if (event instanceof AllocationSample) {
            l = ((AllocationSample)event).classId;
            string = ((AllocationSample)event).tlabSize == 0L ? "_[k]" : "_[i]";
        } else if (event instanceof ContendedLock) {
            l = ((ContendedLock)event).classId;
            string = "_[i]";
        } else if (event instanceof LiveObject) {
            l = ((LiveObject)event).classId;
            string = "_[i]";
        } else {
            return null;
        }
        ClassRef classRef = this.jfr.classes.get(l);
        if (classRef == null) {
            return "null";
        }
        byte[] byArray = this.jfr.symbols.get(classRef.name);
        int n = 0;
        while (byArray[n] == 91) {
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder(this.toJavaClassName(byArray, n, true));
        while (n-- > 0) {
            stringBuilder.append("[]");
        }
        return stringBuilder.append(string).toString();
    }

    private String getMethodName(long l, byte by) {
        String string = this.methodNames.get(l);
        if (string != null) {
            return string;
        }
        MethodRef methodRef = this.jfr.methods.get(l);
        if (methodRef == null) {
            string = "unknown";
        } else {
            ClassRef classRef = this.jfr.classes.get(methodRef.cls);
            byte[] byArray = this.jfr.symbols.get(classRef.name);
            byte[] byArray2 = this.jfr.symbols.get(methodRef.name);
            if (byArray == null || byArray.length == 0 || this.isNativeFrame(by)) {
                string = new String(byArray2, StandardCharsets.UTF_8);
            } else {
                String string2 = this.toJavaClassName(byArray, 0, this.args.dot);
                String string3 = new String(byArray2, StandardCharsets.UTF_8);
                string = string3.isEmpty() ? string2 : string2 + '.' + string3;
            }
        }
        this.methodNames.put(l, string);
        return string;
    }

    private boolean isNativeFrame(byte by) {
        return by >= 3 && by <= 5 && this.jfr.frameTypes.size() > 4;
    }

    private String toJavaClassName(byte[] byArray, int n, boolean bl) {
        int n2 = byArray.length;
        if (n > 0) {
            switch (byArray[n]) {
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 90: {
                    return "boolean";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 76: {
                    ++n;
                    --n2;
                }
            }
        }
        if (this.args.simple) {
            for (int i = n2 - 2; i >= n; --i) {
                if (byArray[i] != 47 || byArray[i + 1] >= 48 && byArray[i + 1] <= 57) continue;
                n = i + 1;
                break;
            }
        }
        String string = new String(byArray, n, n2 - n, StandardCharsets.UTF_8);
        return bl ? string.replace('/', '.') : string;
    }

    private long toTicks(long l) {
        long l2 = l * 1000000L;
        if (l < 0L) {
            l2 += this.jfr.endNanos;
        } else if (l < 1500000000000L) {
            l2 += this.jfr.startNanos;
        }
        return this.jfr.nanosToTicks(l2);
    }

    private static int getMapKey(Map<Integer, String> map, String string) {
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        Arguments arguments = new Arguments(stringArray);
        if (arguments.input == null) {
            System.out.println("Usage: java " + jfr2flame.class.getName() + " [options] input.jfr [output.html]");
            System.out.println();
            System.out.println("options include all supported FlameGraph options, plus the following:");
            System.out.println("  --alloc       Allocation Flame Graph");
            System.out.println("  --live        Include only live objects in allocation profile");
            System.out.println("  --lock        Lock contention Flame Graph");
            System.out.println("  --threads     Split profile by threads");
            System.out.println("  --state LIST  Filter samples by thread states: RUNNABLE, SLEEPING, etc.");
            System.out.println("  --classify    Classify samples into predefined categories");
            System.out.println("  --total       Accumulate the total value (time, bytes, etc.)");
            System.out.println("  --lines       Show line numbers");
            System.out.println("  --bci         Show bytecode indices");
            System.out.println("  --simple      Simple class names instead of FQN");
            System.out.println("  --dot         Dotted class names");
            System.out.println("  --from TIME   Start time in ms (absolute or relative)");
            System.out.println("  --to TIME     End time in ms (absolute or relative)");
            System.out.println("  --collapsed   Use collapsed stacks output format");
            System.exit(1);
        }
        boolean bl = arguments.collapsed || arguments.output != null && arguments.output.endsWith(".collapsed");
        FlameGraph flameGraph = bl ? new CollapsedStacks(arguments) : new FlameGraph(arguments);
        try (JfrReader jfrReader = new JfrReader(arguments.input);){
            new jfr2flame(jfrReader, arguments).convert(flameGraph);
        }
        flameGraph.dump();
    }
}

