/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.cassandra3.apreload.CassandraStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CassandraClusterAggregator
extends SinglePrimaryKeyAggregator<CassandraStats> {
    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, Object> onStartAsync(String cluster) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        CassandraStats stats = (CassandraStats)this.getValue(cluster);
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
            map.put("cluster", cluster);
        }
        return map;
    }

    public Map<String, Object> onErrorAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return context;
        }
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        if (stats != null) {
            stats.onError(traceId);
            context.put("hasError", Boolean.TRUE);
        }
        return context;
    }

    public void onFinallyAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return;
        }
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        Long startTime = (Long)context.get("startTime");
        boolean hasError = Boolean.TRUE.equals(context.get("hasError"));
        String cluster = (String)context.get("cluster");
        if (stats != null && startTime != null) {
            Long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(traceId);
            }
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("Cassandra:" + cluster), (List)TransactionCollector.getTxName(), (String)"Cassandra");
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected Class<CassandraStats> getValueType() {
        return CassandraStats.class;
    }

    protected String primaryKey() {
        return "nodes";
    }

    public String getName() {
        return "cluster";
    }
}

